#ifndef _SCI_H
#define _SCI_H

#include"MC9S08GW64.h"
#include"sci_config.h"     //includes all the defines 



 typedef union 
  {
   unsigned char Byte;
   struct 
   {
    unsigned char  SBRH       :5;        /*Baud rate divisor*/
    unsigned char             :1;         /*Unimplemented*/
    unsigned char RXEDGIE     :1;         /*RxD Input Active Edge Interrupt Enable*/
    unsigned char LBKDIE      :1;         /*LIN Break Detect Interrupt Enable*/
   }Bits;
  }SCI_SCIBDHRegType;

 typedef union 
  {
   unsigned char Byte;
   struct 
   {
    unsigned char PT          :1;         /*Parity type : even/odd */
    unsigned char PE          :1;         /*Parity bit enable*/
    unsigned char ILT         :1;         /*Idle line type select */
    unsigned char WAKE        :1;         /*Reciever wakeup select*/
    unsigned char M           :1;         /*8/9 bit mode select*/
    unsigned char RSRC        :1;         /*Receiver source select*/
    unsigned char SCISWAI     :1;         /*SCI stops in stop mode*/
    unsigned char LOOPS       :1;         /*Loop / normal mode select*/
   }Bits;
  }SCI_SCIC1RegType;

typedef union 
  {
   unsigned char Byte;
   struct 
   {
    unsigned char SBK          :1;         /*Send Break*/
    unsigned char RWU          :1;         /*Reciever wakeup control*/
    unsigned char RE           :1;         /*Reciever enable*/
    unsigned char TE           :1;         /*Transmitter enable*/
    unsigned char ILIE         :1;         /*Idle line interrupt enable*/
    unsigned char RIE          :1;         /*Reciever interrupt enable  */
    unsigned char TCIE         :1;         /*Transmission complete interrupt enable*/
    unsigned char TIE          :1;         /*Transmit interrupt enable*/
   }Bits;
  }SCI_SCIC2RegType;
  
typedef union 
  {
   unsigned char Byte;
   struct 
   {
    unsigned char PF             :1;         /*Parity error flag*/
    unsigned char FE             :1;         /*Framing error flag*/
    unsigned char NF             :1;         /*Noise flag */
    unsigned char OR             :1;         /*Reciever overrun flag*/
    unsigned char IDLE           :1;         /*Idle line flag*/
    unsigned char RDRF           :1;         /*Reciever data reg full flag*/
    unsigned char TC             :1;         /*Transmission complete flag*/
    unsigned char TDRE           :1;         /*Transmit data reg empty flag*/
   }Bits;
  }SCI_SCIS1RegType;
  
  typedef union 
  {
   unsigned char Byte;
   struct 
   {
    unsigned char RAF             :1;         /*Receiver active flag*/
    unsigned char LBKDE           :1;         /*LIN break detection enable*/
    unsigned char BRK13           :1;         /*Break character generation length*/
    unsigned char RWUID           :1;         /*Recieve wakeup idle detect*/
    unsigned char RXINV           :1;         /*Recieve data inversion*/
    unsigned char                 :1;         /*Unimplemented*/
    unsigned char RXEDGIF         :1;         /*RxD Pin Active Edge Interrupt Flag*/
    unsigned char LBKDIF          :1;         /*LIN Break Detect Interrupt Flag*/
   }Bits;
  }SCI_SCIS2RegType;

  typedef union 
  {
   unsigned char Byte;
   struct 
   {
    unsigned char PEIE             :1;         /*Parity error interrupt enable*/
    unsigned char FEIE             :1;         /*Framing error interrupt enable*/
    unsigned char NEIE             :1;         /*Noise error interrupt enable*/
    unsigned char ORIE             :1;         /*Overrun interrupt enable*/
    unsigned char TXINV            :1;         /*Transmit data inversion*/
    unsigned char TXDIR            :1;         /*TxD pin direction in single wire mode*/
    unsigned char T8               :1;         /*9th data bit for transmitter*/
    unsigned char R8               :1;         /*9th data bit for receiver*/
   }Bits;
  }SCI_SCIC3RegType;
  
  
  typedef struct
  {
   SCI_SCIBDHRegType SCIBDH;       //SCI baud rate reg
   unsigned char     SBRL;         //SCI baud rate reg
   SCI_SCIC1RegType  SCIC1;        //SCI control reg 1
   SCI_SCIC2RegType  SCIC2;        //SCI control reg 2
   SCI_SCIS1RegType  SCIS1;        //SCI status reg 1
   SCI_SCIS2RegType  SCIS2;        //SCI status reg 2
   SCI_SCIC3RegType  SCIC3;        //SCI status reg 3
   unsigned char     SCID;         //SCI data reg 
  }SCI;


/* Defines */  
#define SCI_0 0x0078      //starting address of SCI0 registers
#define SCI_1 0x0088      //starting address of SCI1 registers
#define SCI_2 0x1868      //starting address of SCI2 registers
#define SCI_3 0x1870      //starting address of SCI3 registers


#define SCI_Index0 0          //selects SCI0
#define SCI_Index1 1          //selects SCI1
#define SCI_Index2 2          //selects SCI2
#define SCI_Index3 3          //selects SCI3

#define SCI0_RX 0             //indicates that received a data on SCI0
#define SCI1_RX 1             //indicates that received a data on SCI1
#define SCI2_RX 2             //indicates that received a data on SCI2
#define SCI3_RX 3             //indicates that received a data on SCI3
#define SCI0_TX 4             //indicates that transmitted a data from SCI0
#define SCI1_TX 5             //indicates that transmitted a data from SCI1
#define SCI2_TX 6             //indicates that transmitted a data from SCI2
#define SCI3_TX 7             //indicates that transmitted a data from SCI3

extern unsigned char* SCI0_Data;    //stores the data for SCI0 Tx and Rx in case of interrupt
extern unsigned char* SCI1_Data;    //stores the data for SCI1 Tx and Rx in case of interrupt
extern unsigned char* SCI2_Data;    //stores the data for SCI2 Tx and Rx in case of interrupt
extern unsigned char* SCI3_Data;    //stores the data for SCI3 Tx and Rx in case of interrupt

extern unsigned char SCI0_DataLen;  //stores the length of the data to be transmitted or read from SCI0
extern unsigned char SCI1_DataLen;  //stores the length of the data to be transmitted or read from SCI1
extern unsigned char SCI2_DataLen;  //stores the length of the data to be transmitted or read from SCI2
extern unsigned char SCI3_DataLen;  //stores the length of the data to be transmitted or read from SCI3

#define SCI_Interrupt_Enable 1    //enables the interrupt
#define SCI_Interrupt_Disable 0   //disables the interrupt
 
#define SCI_Set_BaudRate_9600(x) SCI_Set_BaudRate(x,9600)      //to set the baud rate 9600bps
#define SCI_Set_BaudRate_19200(x) SCI_Set_BaudRate(x,19200)    //to set the baud rate 19200bps
#define SCI_Set_BaudRate_38400(x) SCI_Set_BaudRate(x,38400)    //to set the baud rate 38400bps
#define SCI_Set_BaudRate_115200(x) SCI_Set_BaudRate(x,115200)  //to set the baud rate 115200bps


/*Functions*/ 
void SCI_Init(unsigned char,void (*p)(unsigned char ,unsigned char));
void SCI_Set_BaudRate(unsigned char ,unsigned int);
void SCI_PutChar(unsigned char,unsigned char);
void SCI_SendArray(unsigned char,unsigned char ,unsigned char* ,unsigned char); 
unsigned char SCI_GetChar(unsigned char);
void SCI_GetArray(unsigned char,unsigned char,unsigned char*,unsigned char);
extern void printf(unsigned char*,...);

#endif